if (!Array.prototype.filter)
{
/*
Makes the "filter" function work in IE 8 and lower 
*/
  Array.prototype.filter = function(fun /*, thisp */)
  {
    "use strict";

    if (this === void 0 || this === null)
      throw new TypeError();

    var t = Object(this);
    var len = t.length >>> 0;
    if (typeof fun !== "function")
      throw new TypeError();

    var res = [];
    var thisp = arguments[1];
    for (var i = 0; i < len; i++)
    {
      if (i in t)
      {
        var val = t[i]; // in case fun mutates this
        if (fun.call(thisp, val, i, t))
          res.push(val);
      }
    }

    return res;
  };
}

                
var $$ = jQuery.noConflict();                        
       
$$(document).ready(function() {

    /*var commonTrackCategory = "undefined";
    var commonTrackSubcategory = $$("h1").first().text();
    commonTrackSubcategory = commonTrackSubcategory.replace(/["'\\\\\n\b\f\n\r\t\v]/g, "\\\$&")
    var commonTrackPageTitle = location.pathname.substring(1);
    if (window.platform) commonTrackCategory = platform;
    if (location.pathname.substring(1) == "SupportArticleView") {
        // current page is article page
        // category is set to "article"
        // pagename equals urlName of article
        commonTrackCategory = "article";
        commonTrackSubcategory = "--Title of some article--";
        commonTrackPageTitle = gup( 'urlname' );
    }
    commonTrackPageTitle = commonTrackPageTitle.replace(/["'\\\\\n\b\f\n\r\t\v]/g, "\\\\$&");
    var commonTrackPhrase = "'pageLoad', {'channel': 'support center', 'category': '" + commonTrackCategory + "','subcategory':'" + commonTrackSubcategory + "','pageTitle':'"+ commonTrackPageTitle + "'}";
    $$("#everyPageTrack").attr("data-tracking",commonTrackPhrase);*/

    // LANGUAGE MODAL WINDOW
    $$('#language-selector, #footer-lang-sel').click(function() {
      $$('#lang-overlay').show();

      $$('#lang-overlay').css("top",($$(window).scrollTop() + ($$(window).height()/2))+"px");
      $$('#fade').show();
      $$('#fade').height($$(document).height());

      $$('#lang-overlay').attr('tabIndex', '0');
      $$('#lang-overlay').attr('aria-hidden', 'false');
      $$('#language-selector').attr('aria-expanded', 'true');
      $$('#footer-lang-sel').attr('aria-expanded', 'true');
      $$('#lang-overlay').focus();
    });
    $$('#fade, #lang-close').click(function() {
      $$('#lang-overlay').hide();

      $$('#fade').hide();

      $$('#lang-overlay').attr('tabIndex', '-1');
      $$('#lang-overlay').attr('aria-hidden', 'true');
      $$('#language-selector').attr('aria-expanded', 'false');
      $$('#footer-lang-sel').attr('aria-expanded', 'false');
    });
});
            
function indexOf2d(arr, val) {
    var index = [-1, -1];

    if (!Array.isArray(arr)) {
        return index;
    }

    arr.some(function (sub, posX) {
        if (!Array.isArray(sub)) {
            return false;
        }

        var posY = sub.indexOf(val);

        if (posY !== -1) {
            index[0] = posX;
            index[1] = posY;
            return true;
        }

        return false;
    });

    return index;  
}

// NEW RESPONSIVE FOOTER SCRIPT
// ============================

var avg = {};
avg.sizes = {};
avg.sizes['xs'] = [0, 479];
avg.sizes['sm'] = [480, 767];
avg.sizes['md'] = [768, 991];
avg.sizes['lg'] = [992, 3000];

+function ($AVG) {
    'use strict';

    // FOOTER PUBLIC CLASS DEFINITION
    // ==============================

    var Footer = function (element, options) {
        this.$element = $AVG(element);
        this.options = $AVG.extend({}, options);
        this.objectSizes = {'xs': true, 'sm': true, 'md': false, 'lg': false};
    };

    Footer.prototype.setState = function (elm) {       
        compareSize(
            this.objectSizes,
            function () {
                elm.addClass('clickable');
                elm.find('.footer-links-content').hide();
                elm.removeClass('active-column');
                elm.attr('aria-expanded', 'false');
                elm.find('ul').attr('tabIndex', '-1');
            },
            function () {
                elm.removeClass('clickable');
                elm.find('.footer-links-content').show();
                elm.removeClass('active-column');
                elm.attr('aria-expanded', 'false');
                elm.find('ul').attr('tabIndex', '-1');
            }
        );
    };

    Footer.prototype.toggle = function (elm) {
        elm.find('.footer-links-content').slideToggle('fast');
        elm.toggleClass('active-column');

        if(elm.hasClass('active-column')) {
            elm.attr('aria-expanded', 'true');
            elm.find('ul').attr('tabIndex', '0');
            elm.find('ul').focus();
        } else {
            elm.attr('aria-expanded', 'false');
            elm.find('ul').attr('tabIndex', '-1');
        }
    };

    /*
     // FOOTER PLUGIN DEFINITION
     // ========================
     */

    function Plugin(option) {
        return this.each(function () {
            var $this = $AVG(this);
            var data = $this.data('bs.footer');
            var options = typeof option === 'object' && option;

            if (!data)
                $this.data('bs.footer', (data = new Footer(this, options)));

            if (option === 'toggle'){
                data.toggle($this);
            } else if (option){
                data.setState($this);
            }
        });
    }

    var old = $AVG.fn.footer;

    $AVG.fn.footer = Plugin;
    $AVG.fn.footer.Constructor = Footer;


    // FOOTER NO CONFLICT
    // ==================

    $AVG.fn.footer.noConflict = function () {
        $AVG.fn.footer = old;
        return this;
    };

    var clickHandler = function (e) {
        //e.preventDefault();
        Plugin.call($AVG(this), 'toggle');
    };

    var readyHandler = function (e) {
        var els = '[data-footer="toggle"]';
        Plugin.call($AVG(els), 'setState');
    };

    $AVG(document)
            .on('click.bs.footer.data-api', '.footer-links.clickable', clickHandler)
            .ready(readyHandler);

    $AVG(window).resize(function () {
        waitForFinalEvent(function () {
            readyHandler();
        }, 100, "footer-resize");
    });

}(jQuery.noConflict());

function compareSize(object, callbackTrue, callbackFalse) {
    $$.each(object, function(k, v) {
        if (getViewportSize('x') >= avg.sizes[k][0] && getViewportSize('x') <= avg.sizes[k][1]) {
            if (v) {
                callbackTrue();
            } else {
                callbackFalse();
            }
        }
    });
}
function getViewportSize(c) {
    if (c == 'x') return window.innerWidth || document.documentElement.clientWidth || document.body.clientWidth;
    if (c == 'y') return ($$(window).outerHeight());
}

var waitForFinalEvent = (function() {
    var timers = {};
    return function(callback, ms, uniqueId) {
        if (!uniqueId) {
            uniqueId = "Don't call this twice without a uniqueId";
        }
        if (timers[uniqueId]) {
            clearTimeout(timers[uniqueId]);
        }
        timers[uniqueId] = setTimeout(callback, ms);
    };
})();

//cookie accept bar
+function($AVG){

    'use strict';

    $AVG(document).ready(function () {
        if (document.cookie.indexOf('sat_track') < 0) {
            $AVG('#cookie-bar').show();
            $AVG('#cookieSubmit').click(function() {
                setCookie('sat_track',true,730,'.avg.com');
                setCookie('sat_track',true,730,'.force.com');
                $AVG('#cookie-bar').slideToggle('fast'); 
            });
        }
    });
}(jQuery.noConflict());

function setCookie(name, value, days, domain) {
    var date = new Date();
    date.setTime(date.getTime() + (days*24*60*60*1000));
    var expire = "; expires="+ date.toUTCString();
    var address = "; domain=" + domain;
    document.cookie = name + "=" + value + expire  + address +"; path=/";
}